use criterion::{black_box, criterion_group, criterion_main, Criterion};
use sum_vector_rust::generate;
use sum_vector_rust::sums;

const LENGTH: usize = 12800000;

pub fn sum_benchmark(c: &mut Criterion) {
    let mut group = c.benchmark_group("Summing");
    group.bench_function("vec_sum_for_loop", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_for_loop(&v));
        })
    });
    group.bench_function("vec_sum_two_accumulators", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_two_accumulators(&v));
        })
    });
    group.bench_function("vec_sum_fold", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_fold(&v));
        })
    });
    group.bench_function("vec_sum_method", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_method(&v));
        })
    });
    group.bench_function("vec_sum_algebraic", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_algebraic(&v));
        })
    });
    group.bench_function("vec_sum_parallel", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_parallel(&v));
        })
    });
    group.bench_function("vec_sum_simd", |b| {
        let v = generate::random_vec(LENGTH);
        b.iter(|| {
            black_box(sums::vec_sum_simd(&v));
        })
    });

    group.finish();
}

criterion_group!(benches, sum_benchmark);
criterion_main!(benches);
